/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.liquid_blaze_burner;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerTileEntity;
import com.mrh0.createaddition.index.CATileEntities;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;

public class LiquidBlazeBurnerBlock
extends HorizontalDirectionalBlock
implements IBE<LiquidBlazeBurnerTileEntity>,
IWrenchable {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> HEAT_LEVEL = EnumProperty.m_61587_((String)"blaze", BlazeBurnerBlock.HeatLevel.class);

    public LiquidBlazeBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT_LEVEL, f_54117_});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos.m_7494_());
        if (!(tileEntity instanceof BasinBlockEntity)) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)tileEntity;
        basin.notifyChangeOfContents();
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> list) {
        list.add((Object)AllItems.EMPTY_BLAZE_BURNER.asStack());
        super.m_49811_(group, list);
    }

    public Class<LiquidBlazeBurnerTileEntity> getBlockEntityClass() {
        return LiquidBlazeBurnerTileEntity.class;
    }

    public BlockEntityType<? extends LiquidBlazeBurnerTileEntity> getBlockEntityType() {
        return (BlockEntityType)CATileEntities.LIQUID_BLAZE_BURNER.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return super.m_142194_(pos, state);
    }

    public Item m_5456_() {
        return ((BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get()).m_5456_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        BlazeBurnerBlock.HeatLevel heat = (BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL);
        if (AllItems.GOGGLES.isIn(heldItem) && heat != BlazeBurnerBlock.HeatLevel.NONE) {
            return this.onBlockEntityUse((BlockGetter)world, pos, bbte -> {
                if (bbte.goggles) {
                    return InteractionResult.PASS;
                }
                bbte.goggles = true;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        if (heldItem.m_41619_() && heat != BlazeBurnerBlock.HeatLevel.NONE) {
            return this.onBlockEntityUse((BlockGetter)world, pos, bbte -> {
                if (!bbte.goggles) {
                    return InteractionResult.PASS;
                }
                bbte.goggles = false;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        boolean doNotConsume = player.m_7500_();
        boolean forceOverflow = !(player instanceof FakePlayer);
        InteractionResultHolder<ItemStack> res = LiquidBlazeBurnerBlock.tryInsert(state, world, pos, heldItem, doNotConsume, forceOverflow, false);
        ItemStack leftover = (ItemStack)res.m_19095_();
        if (!(world.f_46443_ || doNotConsume || leftover.m_41619_())) {
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, leftover);
            } else if (!player.m_150109_().m_36054_(leftover)) {
                player.m_36176_(leftover, false);
            }
        }
        return res.m_19089_() == InteractionResult.SUCCESS ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> tryInsert(BlockState state, Level world, BlockPos pos, ItemStack stack, boolean doNotConsume, boolean forceOverflow, boolean simulate) {
        if (!state.m_155947_()) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof LiquidBlazeBurnerTileEntity)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        LiquidBlazeBurnerTileEntity burnerTE = (LiquidBlazeBurnerTileEntity)te;
        if (burnerTE.isCreativeFuel(stack)) {
            if (!simulate) {
                burnerTE.applyCreativeFuel();
            }
            return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
        }
        if (!burnerTE.tryUpdateFuel(stack, forceOverflow, simulate)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        if (!doNotConsume) {
            ItemStack container;
            ItemStack itemStack = container = stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_;
            if (!world.f_46443_) {
                stack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)container);
        }
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (p_220071_4_ == CollisionContext.m_82749_()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.m_5940_(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level p_180641_2_, BlockPos p_180641_3_) {
        return Math.max(0, ((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).ordinal() - 1);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, Random random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (!((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SMOULDERING)) {
            return;
        }
        world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
    }
}

